﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Winfoot_7_SDK;
using Microsoft.Win32;

namespace WinfootDefaultPerformancePlugin.Controls.Strategy
{
    public interface IDisablePagingExecutiveStrategy
    {
        void Write(bool b);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class DisablePagingExecutiveDefaultStrategy : ICorrespondenceOS, IDisablePagingExecutiveStrategy
    {
        public DisablePagingExecutiveDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsVista_SP3,
#if DEBUG
                                           OS.WindowsSeven,
                                           OS.WindowsSeven_SP1,
                                           OS.WindowsSeven_SP2
#endif
                                       };
        }

        private string RegName = "DisablePagingExecutive";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IDisablePagingExecutiveStrategy メンバ

        public void Write(bool b)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management");

            if (b)
            {
                registryKey.SetValue(RegName, 1, RegistryValueKind.DWord);
            }
            else
            {
                registryKey.SetValue(RegName, 0, RegistryValueKind.DWord);
            }
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management");
            if (registryKey != null)
            {
                return
                    new WFRegistry(
                        @"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management",
                       RegName, registryKey.GetValue(RegName, 0),
                        RegistryValueKind.DWord, RegOperation.ValueWrite);
            }
            return
                new WFRegistry(
                    @"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management",
                    RegName, 0, RegistryValueKind.DWord, RegOperation.ValueWrite);
        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry>{Read()};
        }

        #endregion
    }

    public class DisablePagingExecutiveController
    {
        public DisablePagingExecutiveController(DisablePagingExecutive disablePagingExecutive,IDisablePagingExecutiveStrategy strategy)
        {
            DisablePagingExecutive = disablePagingExecutive;
            Strategy = strategy;
        }

        public DisablePagingExecutive DisablePagingExecutive { get; set; }
        public IDisablePagingExecutiveStrategy Strategy { get; set; }

        public void Read()
        {
            WFRegistry wfRegistry= Strategy.Read();
            if ((int) wfRegistry.Value == 1)
            {
                DisablePagingExecutive.SetDisablePagingExecutiveState(true);
            }
            else
            {
                DisablePagingExecutive.SetDisablePagingExecutiveState(false);
            }
        }

        public void Write()
        {
            Strategy.Write(DisablePagingExecutive.GetDisablePagingExecutiveState());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
}